/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.util.io;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public class AtomicFileOutput
implements Closeable {
    private final Path file;
    private final Path newFile;
    private final Path oldFile;
    private final BufferedOutputStream outputStream;
    private boolean ok;

    public AtomicFileOutput(Path file) throws IOException {
        this.file = file;
        String fn = file.getFileName().toString();
        this.newFile = file.resolveSibling(fn + ".new");
        this.oldFile = file.resolveSibling(fn + ".old");
        this.ok = false;
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        this.outputStream = new BufferedOutputStream(Files.newOutputStream(this.newFile, new OpenOption[0]));
    }

    public BufferedOutputStream getOutputStream() {
        return this.outputStream;
    }

    public void markOk() {
        this.ok = true;
    }

    @Override
    public void close() throws IOException {
        try {
            this.outputStream.close();
        }
        catch (IOException e) {
            this.ok = false;
        }
        if (this.ok) {
            if (Files.exists(this.file, new LinkOption[0])) {
                Files.copy(this.file, this.oldFile, StandardCopyOption.REPLACE_EXISTING);
            }
            Files.move(this.newFile, this.file, StandardCopyOption.ATOMIC_MOVE);
            Files.deleteIfExists(this.oldFile);
        } else {
            Files.deleteIfExists(this.newFile);
        }
    }
}

